' "DHT Test Emulator 04.bas"
'  One pin version. Link GP1 and Gnd. to other Pico.
'  If wires are short no pullup resistor is needed.
SetPin GP1, DIn, pullup

Dim integer a(83), b1, b2, b3, b4, b5, word, n, m, q=0 'start value for byte incrementer
Dim float t, z= .9  '"wake" pulse duration - 0.9 = DHT22, 19 = DHT11

Do
  Math Set 50, a() : a(0)=80 : a(1)=80

'  Input "type the 4 bytes "; b1, b2, b3, b4 'enter byte values at console

'  If b1 = 0 Then ' set default values if zero Input
    b1=1 : b2=166 : b3=1 : b4=q 'choose the initial byte values
'  EndIf

  b5 = (b1+b2+b3+b4) And 255 'make checksum
'  Print "Sending "; b1, b2, b3, b4, b5

  word = ((b1 And 255)<<32)+((b2 And 255)<<24)+((b3 And 255)<<16)+((b4 And 255)<<8)+b5
  m=0 : Print Bin$(word,40)
  For n=81 To 2 Step -2
    a(n) = 27 + 43 * ((word >> m) And 1)
'    Print n,m,a(n)
    Inc m
  Next

  Print "Waiting to receive HUMID command (either type 0 or 1)"

  Do While Pin(GP1) : Loop
  t=Timer + z '0.8 = DHT22, 15 = DHT11
  SetPin GP1, off :Pin(GP1) = 1:SetPin GP1, DOut
  Do : Loop Until Timer>t

  Device BitStream GP1, 83, a() ': endif

  SetPin gp1, off : SetPin gp1, din, pullup

  Inc q
  Print "Sent "; b1, b2, b3, b4, "CSum"; b5, "Byte Sum ="; b1+b2+b3+b4
Loop
End
'other Pico
'do :humid gp1,t,h,0 :? t,h,,time$ :pause 1000 : loop
                                                                                                                      